<html>
<head>
    <link href="https://fonts.googleapis.com/css?family=Montserrat:700|Open+Sans" rel="stylesheet">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <style type="text/css">
        * { box-sizing: border-box; }
        ::selection { background: #256AAF; color: #fff; }
        ::-moz-selection { background: #256AAF; color: #fff; }
        .icon-yes,
        .icon-no { font-weight: bold; margin-right: 5px; }
        .icon-yes { color: #1abc9c; }
        .icon-no { color: red; }
        .text-error { color: #e74c3c; }
        body { padding: 15px; margin: 0; background: #256AAF; color: #3f5163;  font-weight: 400; font-family: 'Open Sans', sans-serif; }
        #wrapper { max-width: 500px; width: 100%; margin: 10% auto 0; }
        #table { width: 100%; margin-top: 30px; background-color: #fff; border-radius: 5px; }
        #table th,
        #table td { padding: .6em 1em; border-bottom: 1px solid #ccc; }
        #table th { text-align: center; }
        #table tr:last-child th,
        #table tr:last-child td { border: none; }
        h1, h2 { font-family: 'Montserrat', sans-serif; margin: 0; text-align: center; color: #fff; }
        h1 { font-size: 50px; }
        h2 { font-size: 40px; color: #e2e1ee; }
        #result { margin-top: 30px; text-align: center; color: #e2e1ee; }
    </style>
</head>
<body>
    <div id="wrapper">
        <h1>AAWP</h1>
        <h2>Server Check Tool</h2>
        <?php
        $passed = true;

        $enabled = '<span class="icon-yes"><i class="fa fa-check-circle-o" aria-hidden="true"></i></span>Enabled</strong></span>';
        $disabled = '<span class="icon-no"><i class="fa fa-times-circle-o" aria-hidden="true"></i></span>Disabled</strong></span>';
        ?>
        <table id="table">
            <tbody>
            <tr>
                <th>PHP</th>
                <td><?php if ( version_compare ( phpversion(), '7.1', '<') ) { ?>
                        <span class="icon-no"><i class="fa fa-times-circle-o" aria-hidden="true"></i></span><strong><?php echo phpversion(); ?></strong>
                        <br /><span class="text-error"><strong>PHP Version 7.1 or newer required</strong></span>
                        <?php $passed = false; ?>
                    <?php } else { ?>
                        <span class="icon-yes"><i class="fa fa-check-circle-o" aria-hidden="true"></i></span><strong><?php echo phpversion(); ?></strong>
                    <?php } ?>
                </td>
            </tr>
            <tr>
                <th>PHP "cURL" extension</th>
                <td>
                    <?php
                    if ( function_exists('curl_version') ) {
                        echo $enabled;

                        $curl_data = curl_version();

                        if ( ! empty( $curl_data['version'] ) )
                            echo '<br /><small>(Version ' . $curl_data['version'] . ')</small>';
                    } else {
                        echo $disabled;
                        $passed = false;
                    }
                    ?>
                </td>
            </tr>
            <tr>
                <th>PHP "curl_exec" function</th>
                <td>
                    <?php if ( function_exists( 'curl_exec' ) ) {
                        echo $enabled;
                    } else {
                        echo $disabled;
                        $passed = false;
                    } ?>
                </td>
            </tr>
            <tr>
                <th>PHP "SOAP" extension</th>
                <td>
                    <?php if ( extension_loaded('soap') ) {
                        echo $enabled;
                    } else {
                        echo $disabled;
                        $passed = false;
                    } ?>
                </td>
            </tr>
            <tr>
                <th>PHP "mbstring" extension</th>
                <td>
                    <?php if ( extension_loaded('mbstring') ) {
                        echo $enabled;
                    } else {
                        echo $disabled;
                        $passed = false;
                    } ?>
                </td>
            </tr>
            <tr>
                <th>PHP "allow_url_fopen" setting</th>
                <td>
                    <?php if ( ini_get('allow_url_fopen') ) {
                        echo $enabled;
                    } else {
                        echo $disabled;
                        $passed = false;
                    } ?>
                </td>
            </tr>
            </tbody>
        </table>
        <p id="result">
            <?php echo ( $passed ) ? '<i class="fa fa-smile-o" aria-hidden="true"></i> Everything is fine!' : '<i class="fa fa-frown-o" aria-hidden="true"></i> Some depedencies are missing. Please contact your hosting provider in order to update/activate then.'; ?>
        </p>
    </div>

</body>
</html>